Attribute VB_Name = "VBMPUSBAPI"
'======================================================================================
'        Rutinas de llamada a la libreria MPUSBAPI.DLL
'======================================================================================

Option Explicit

'--------------------------------------------------------------------------------------
' Convenciones de llamada en C
'       DWORD   _MPUSBGetDLLVersion(void)
'       DWORD   _MPUSBGetDeviceCount(PCHAR pVID_PID)
'       HANDLE  _MPUSBOpen(DWORD instance, PCHAR pVID_PID, PCHAR pEP, DWORD dwDir, DWORD dwReserved);
'       DWORD   _MPUSBRead(HANDLE handle, PVOID pData, DWORD dwLen, PDWORD pLength, DWORD dwMilliseconds);
'       DWORD   _MPUSBWrite(HANDLE handle, PVOID pData, DWORD dwLen, PDWORD pLength, DWORD dwMilliseconds);
'       DWORD   _MPUSBReadInt(HANDLE handle, PVOID pData, DWORD dwLen, PDWORD pLength, DWORD dwMilliseconds);
'--------------------------------------------------------------------------------------

'--------------------------------------------------------------------------------------
' Funciones equivalentes para llamar desde el VB
'--------------------------------------------------------------------------------------
Public Declare Function MPUSBGetDLLVersion Lib "mpusbapi.dll" () As Long
Public Declare Function MPUSBGetDeviceCount Lib "mpusbapi.dll" (ByVal pVID_PID As String) As Long
Public Declare Function MPUSBOpen Lib "mpusbapi.dll" (ByVal instance As Long, ByVal pVID_PID As String, ByVal pEP As String, ByVal dwDir As Long, ByVal dwReserved As Long) As Long
Public Declare Function MPUSBClose Lib "mpusbapi.dll" (ByVal handle As Long) As Long
Public Declare Function MPUSBRead Lib "mpusbapi.dll" (ByVal handle As Long, ByVal pData As Long, ByVal dwLen As Long, ByRef pLength As Long, ByVal dwMilliseconds As Long) As Long
Public Declare Function MPUSBWrite Lib "mpusbapi.dll" (ByVal handle As Long, ByVal pData As Long, ByVal dwLen As Long, ByRef pLength As Long, ByVal dwMilliseconds As Long) As Long
Public Declare Function MPUSBReadInt Lib "mpusbapi.dll" (ByVal handle As Long, ByVal pData As Long, ByVal dwLen As Long, ByRef pLength As Long, ByVal dwMilliseconds As Long) As Long

'--------------------------------------------------------------------------------------
' Constantes para la WIN32 API
'--------------------------------------------------------------------------------------
Public Const INVALID_HANDLE_VALUE = -1
Public Const ERROR_INVALID_HANDLE = 6&

'--------------------------------------------------------------------------------------
' Funciones de la WIN32 API
'--------------------------------------------------------------------------------------
Public Declare Function GetLastError Lib "kernel32" () As Long
Public Declare Function timeGetTime Lib "winmm.dll" () As Long

'--------------------------------------------------------------------------------------
' Constantes de conectividad con el PIC
'--------------------------------------------------------------------------------------
Public Const vid_pid = "vid_04d8&pid_0011"          ' Vendor id (Microchip) y Perifrico id
Public Const out_pipe = "\MCHP_EP1"
Public Const in_pipe = "\MCHP_EP1"

Public Const MPUSB_FAIL = 0
Public Const MPUSB_SUCCESS = 1

Public Const MP_WRITE = 0
Public Const MP_READ = 1

'--------------------------------------------------------------------------------------
' IN_PIPE y OUT_PIPE variables pblicas
'--------------------------------------------------------------------------------------
Public myInPipe As Long
Public myOutPipe As Long

'--------------------------------------------------------------------------------------
' Abrimos el perifrico
'--------------------------------------------------------------------------------------
Sub OpenMPUSBDevice()
    Dim tempPipe As Long
    Dim count As Long

    tempPipe = INVALID_HANDLE_VALUE
    count = MPUSBGetDeviceCount(vid_pid)

    If count > 0 Then
        myOutPipe = MPUSBOpen(0, vid_pid, out_pipe, MP_WRITE, 0)
        myInPipe = MPUSBOpen(0, vid_pid, in_pipe, MP_READ, 0)

        If myOutPipe = INVALID_HANDLE_VALUE Or myInPipe = INVALID_HANDLE_VALUE Then
            MsgBox str(myOutPipe) + " " + str(myInPipe) + " Error al abrir los pipes"
            myOutPipe = INVALID_HANDLE_VALUE
            myInPipe = INVALID_HANDLE_VALUE
        End If
    Else
        MsgBox "ET-PICUSB4550 not found. "
    End If
End Sub

'--------------------------------------------------------------------------------------
' Cerramos el perifrico
'--------------------------------------------------------------------------------------
Sub CloseMPUSBDevice()
    If myOutPipe <> INVALID_HANDLE_VALUE Then
        MPUSBClose (myOutPipe)
        myOutPipe = INVALID_HANDLE_VALUE
    End If
    
    If myInPipe <> INVALID_HANDLE_VALUE Then
        MPUSBClose (myInPipe)
        myInPipe = INVALID_HANDLE_VALUE
    End If
End Sub

'--------------------------------------------------------------------------------------
' Funcin Send_Receive
'
' SendData:         Matriz de bytes con los datos a mandar
' SendLength:       Longitud de datos a mandar
' ReceiveData:      Matriz de datos a recibir
' ReceiveLength:    Nmero de bytes a recibir
' SendDelay:        Time-out para el envo en milisegundos
' ReceiveDelay:     Time-out para la recepccin en milisegundos
'--------------------------------------------------------------------------------------

Function Send_Receive(ByRef SendData() As Byte, SendLength As Long, _
                      ByRef ReceiveData() As Byte, ByRef ReceiveLength As Long, _
                      ByVal SendDelay As Long, ByVal ReceiveDelay As Long) As Long
                    

    Dim SentDataLength As Long
    Dim ExpectedReceiveLength As Long

    ExpectedReceiveLength = ReceiveLength
    
    If (myOutPipe <> INVALID_HANDLE_VALUE And myInPipe <> INVALID_HANDLE_VALUE) Then
        If (MPUSBWrite(myOutPipe, VarPtr(SendData(0)), SendLength, SentDataLength, SendDelay) = MPUSB_SUCCESS) Then
            If (MPUSBRead(myInPipe, VarPtr(ReceiveData(0)), ExpectedReceiveLength, ReceiveLength, ReceiveDelay) = MPUSB_SUCCESS) Then
                If (ReceiveLength = ExpectedReceiveLength) Then
                    Send_Receive = 1                ' Todo correcto
                    Exit Function
                ElseIf (ReceiveLength < ExpectedReceiveLength) Then
                    Send_Receive = 2                ' Envo correcto pero
                    Exit Function                   ' Recepccin fallida
                End If
            Else
                CheckInvalidHandle                  ' Mensaje de error
            End If
        Else
            CheckInvalidHandle                      ' Mensaje de error
        End If
    End If
    
    Send_Receive = 0                                ' Operacin fallida

End Function

'--------------------------------------------------------------------------------------
' Presenta el tipo de error
'--------------------------------------------------------------------------------------
Sub CheckInvalidHandle()
    If (GetLastError() = ERROR_INVALID_HANDLE) Then
        ' La causa ms habitual es que el circuito est desconectado
        CloseMPUSBDevice
    Else
        MsgBox "Cdigo de error: " + str(GetLastError())
    End If
End Sub

'--------------------------------------------------------------------------------------
' Funcin Send
'
' SendData:         Matriz de bytes con los datos a mandar
' SendLength:       Longitud de datos a mandar
' SendDelay:        Time-out para el envo en milisegundos
'--------------------------------------------------------------------------------------
Function Send(ByRef SendData() As Byte, SendLength As Long, ByVal SendDelay As Long) As Long
    Dim SentDataLength As Long
    
    If (myOutPipe <> INVALID_HANDLE_VALUE And myInPipe <> INVALID_HANDLE_VALUE) Then
        If (MPUSBWrite(myOutPipe, VarPtr(SendData(0)), SendLength, SentDataLength, SendDelay) = MPUSB_SUCCESS) Then
            Send = 1                            ' Todo correcto
            Exit Function
        Else
            CheckInvalidHandle                  ' Mensaje de error
        End If
    End If
    Send = 0                                    ' Operacin fallida
End Function
